/*******************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 *******************************************************************************

   Filename:
    $Workfile: EplCnStack_API.h $

    $GlobalRev: unknown $
    $Version: V2.1.53.0 $
    $Packaged: 2015-10-26 16:18 $

   Targets:

   Description:

      API definition of NMT task

  Functions:


   Changes:

    Version     Date        Author    Description
     ---------------------------------------------------------------------------
    3           21.04.2008  sb        added host name / Gw address capability
    2           30.11.2007  sb        corrected error result if EplCnInterface initialization fails
    1           01.10.2007  SB        created
*******************************************************************************/

#ifndef EPLV2_CN_API_H_INCLUDED
#define EPLV2_CN_API_H_INCLUDED

#include "EplCnStack_OsTypes.h"
#include "EplCn_Public.h"

#include "EplCnStack_Config.h"
#include "EplCnStack_NmtErrorCodes.h"

#include "Od2_Public.h"

#define EPLCN_MAX_NUMBER_OF_STATUS_ENTRIES  32

/******************************************************************************
 * Result codes for EplCn Stack
 */
enum EPL_CN_RESULT_Ttag
{
  EPL_CN_RESULT_SUCCESS,
  EPL_CN_RESULT_INVALID_STATE_CHANGE,
  EPL_CN_RESULT_FAILED_TO_LOCK_MUTEX,
  EPL_CN_RESULT_OUT_OF_MEMORY,
  EPL_CN_RESULT_COULD_NOT_CREATE_SDO_MUTEX,
  EPL_CN_RESULT_COULD_NOT_CREATE_NMT_MUTEX,
  EPL_CN_RESULT_COULD_NOT_CREATE_SDO_TASK,
  EPL_CN_RESULT_COULD_NOT_CREATE_NMT_TASK,
  EPL_CN_RESULT_COULD_NOT_CREATE_SDO_SIGNAL,
  EPL_CN_RESULT_COULD_NOT_CREATE_NMT_SIGNAL,
  EPL_CN_RESULT_COULD_NOT_CREATE_BASIC_ETH_TIMER,
  EPL_CN_RESULT_COULD_NOT_CREATE_SOC_TIMER,
  EPL_CN_RESULT_COULD_NOT_CREATE_SEQU_LAYER_TIMER,
  EPL_CN_RESULT_COULD_NOT_CREATE_OBJECT_DICTIONARY,
  EPL_CN_RESULT_EMERGENCY_QUEUE_OVERFLOW,
  EPL_CN_RESULT_INVALID_STATUS_ENTRY_INDEX,
  EPL_CN_RESULT_COULD_NOT_LOCK_MUTEX,
  EPL_CN_RESULT_INVALID_STATIC_FIELD_BIT_NUMBER,
  EPL_CN_RESULT_RESET_FAILED,
  EPL_CN_RESULT_INVALID_PARAMETER,
  EPL_CN_RESULT_INVALID_STATUS_ENTRY_COUNT,
  EPL_CN_RESULT_FAILED_TO_INITIALIZE_EPLCN_INTERFACE
};

typedef int EPL_CN_RESULT_T;

/******************************************************************************
 * Stack Handle definition
 */
typedef struct EPLCN_STACK_Ttag* EPLCN_STACK_HANDLE_T;

/******************************************************************************
 * Stack Initialization
 */
EPL_CN_RESULT_T EplCn_Stack_Initialize( const EPLCN_INITIALIZE_STACK_T* ptStackParameters,
                                        EPLCN_STACK_HANDLE_T*           phStackHandle);

void EplCn_Stack_Deinitialize(EPLCN_STACK_HANDLE_T hStackHandle);

void
EplCn_Stack_ModifyFeatureFlags(   EPLCN_STACK_HANDLE_T  ptStackHandle,
                                  UINT32                ulSetFeatureFlags,
                                  UINT32                ulClrFeatureFlags);

void
EplCn_Stack_SetDeviceType(        EPLCN_STACK_HANDLE_T  ptStackHandle,
                                  UINT32                ulDeviceType);

void EplCn_Stack_UpdateIdentity(  EPLCN_STACK_HANDLE_T  hStackHandle,
                                  UINT32                ulVendorId,
                                  UINT32                ulProductCode,
                                  UINT32                ulRevisionNumber,
                                  UINT32                ulSerialNumber,
                                  UINT8                 abHostName[32],
                                  UINT32                ulGatewayAddress);

void EplCn_Stack_UpdatePollInOutSizes(  EPLCN_STACK_HANDLE_T    hStackHandle,
                                        UINT16                  usPReqSize,
                                        UINT16                  usPResSize);

void
EplCn_Stack_UpdateInOutSizes(       EPLCN_STACK_HANDLE_T    ptStackHandle,
                                    UINT16                  usPReqSize,
                                    UINT16                  usPResSize);

void
EplCnStack_Enable(EPLCN_STACK_HANDLE_T ptStackHandle);

void
EplCnStack_Disable(EPLCN_STACK_HANDLE_T ptStackHandle);

/******************************************************************************
 * Configuration
 */
void
EplCn_Stack_SetNodeAddress(             EPLCN_STACK_HANDLE_T    hStackHandle,
                                        UINT8                   bNodeId);

void
EplCn_Stack_SetCycleLength(             EPLCN_STACK_HANDLE_T    hStackHandle,
                                        UINT32                  ulCycleLen);

void
EplCn_Stack_SetSoCJitterRange(          EPLCN_STACK_HANDLE_T    hStackHandle,
                                        UINT32                  ulSoCJitterRange);

void
EplCn_Stack_SetCollisionThreshold(      EPLCN_STACK_HANDLE_T    hStackHandle,
                                        UINT32                  ulThreshold);

void
EplCn_Stack_SetCrcErrorThreshold(       EPLCN_STACK_HANDLE_T    hStackHandle,
                                        UINT32                  ulThreshold);

void
EplCn_Stack_SetLossSoCThreshold(        EPLCN_STACK_HANDLE_T    hStackHandle,
                                        UINT32                  ulThreshold);

void
EplCn_Stack_SetLossPReqThreshold(       EPLCN_STACK_HANDLE_T    hStackHandle,
                                        UINT32                  ulThreshold);

void
EplCn_Stack_SetLossSoAThreshold(        EPLCN_STACK_HANDLE_T    hStackHandle,
                                        UINT32                  ulThreshold);

void
EplCn_Stack_SetSoCJitterThreshold(      EPLCN_STACK_HANDLE_T    hStackHandle,
                                        UINT32                  ulThreshold);

UINT32
EplCn_Stack_GetCollisionThreshold(      EPLCN_STACK_HANDLE_T    hStackHandle);

UINT32
EplCn_Stack_GetCrcErrorThreshold(       EPLCN_STACK_HANDLE_T    hStackHandle);

UINT32
EplCn_Stack_GetLossSoCThreshold(        EPLCN_STACK_HANDLE_T    hStackHandle);

UINT32
EplCn_Stack_GetLossPReqThreshold(       EPLCN_STACK_HANDLE_T    hStackHandle);

UINT32
EplCn_Stack_GetLossSoAThreshold(        EPLCN_STACK_HANDLE_T    hStackHandle);

UINT32
EplCn_Stack_GetSoCJitterThreshold(      EPLCN_STACK_HANDLE_T    hStackHandle);

/******************************************************************************
 * Device Information
 */
UINT16
EplCn_Nmt_GetDeviceProfileNumber(       EPLCN_STACK_HANDLE_T    hStackHandle);

/******************************************************************************
 * Error State Entry
 */
void EplCn_Nmt_EnterErrorState(   EPLCN_STACK_HANDLE_T  hStackHandle,
                                  UINT16                usProfile,
                                  UINT16                usErrorCode);

/******************************************************************************
 * Node Restart configuration
 */
void EplCn_Nmt_ResetNode(               EPLCN_STACK_HANDLE_T  hStackHandle);

void EplCn_Nmt_ReconfigureSoCTrigger(   EPLCN_STACK_HANDLE_T  hStackHandle,
                                        UINT8                 bSoCTriggerConfig,
                                        UINT32                ulSoCTriggerDelay,
                                        UINT32                ulSoCTriggerLength);

/******************************************************************************
 * State Notify Callback
 */
typedef void(* EPLCN_NMT_STATE_NOTIFY_FN_T)(  EPLCN_STACK_HANDLE_T  hStackHandle,
                                              UINT8                 bNmtState,
                                              UINT16                usProfile,
                                              UINT16                usErrorCode,
                                              EPLv2_CN_BOOLEAN      fErrorLedOn,
                                              void*                 pvParam);

void EplCn_Nmt_SetNmtStateCallback( EPLCN_STACK_HANDLE_T        hStackHandle,
                                    EPLCN_NMT_STATE_NOTIFY_FN_T pfnCallback,
                                    void*                       pvParam);

/******************************************************************************
 * Enable Ready To Operate Callback
 */
typedef void(* EPLCN_NMT_ENABLE_RDY_TO_OP_FN_T)(EPLCN_STACK_HANDLE_T hStackHandle, void* pvParam);

void EplCn_Nmt_SetNmtEnableRdyToOpCallback( EPLCN_STACK_HANDLE_T            hStackHandle,
                                            EPLCN_NMT_ENABLE_RDY_TO_OP_FN_T pfnCallback,
                                            void*                           pvParam);

/******************************************************************************
 * Explicit State Enter calls (depending on application)
 */
EPL_CN_RESULT_T EplCn_Nmt_ConfirmEnableReadyToOperate(EPLCN_STACK_HANDLE_T hStackHandle);

EPL_CN_RESULT_T EplCn_Nmt_EnterResetApplication(EPLCN_STACK_HANDLE_T hStackHandle);

EPL_CN_RESULT_T EplCn_Nmt_EnterResetCommunication(EPLCN_STACK_HANDLE_T hStackHandle);

EPL_CN_RESULT_T EplCn_Nmt_EnterResetConfiguration(  EPLCN_STACK_HANDLE_T  hStackHandle,
                                                    UINT8                 bNodeAddress);

EPL_CN_RESULT_T EplCn_Nmt_EnterCnStateMachine(EPLCN_STACK_HANDLE_T hStackHandle);

/******************************************************************************
 * State Machine Query Services
 */
UINT8 EplCn_Nmt_GetState(EPLCN_STACK_HANDLE_T hStackHandle);

/******************************************************************************
 * EPL CN HAL access functions
 */
EPLCN_HANDLE_T EplCn_GetInterface(EPLCN_STACK_HANDLE_T hStackHandle);

/******************************************************************************
 * EPL CN ObjDict access function
 */
OD2_OBJDICT_HANDLE EplCn_GetObjectDictionary(EPLCN_STACK_HANDLE_T hStackHandle);

/******************************************************************************
 * Status Entry and Emergency History/Queue functions
 */
typedef struct EPLCN_STACK_ERROR_ENTRY_Ttag
{
  UINT16 usErrorType;
  UINT16 usErrorCode;
  UINT32 aulTimestamp[2];
  UINT8  abAdditionalInformation[8];
} EPLCN_STACK_ERROR_ENTRY_T;

#define EPLCN_ERROR_ENTRY_TYPE_STATUS                     0x8000
#define EPLCN_ERROR_ENTRY_TYPE_SEND                       0x4000

#define EPLCN_ERROR_ENTRY_MODE_MASK_IN_TYPE               0x3000
#define EPLCN_ERROR_ENTRY_MODE_ERROR_STATUS_CLEARED       0x0000
#define EPLCN_ERROR_ENTRY_MODE_ERROR_OCCURED_AND_ACTIVE   0x1000
#define EPLCN_ERROR_ENTRY_MODE_ERROR_WAS_CLEARED          0x2000
#define EPLCN_ERROR_ENTRY_MODE_ERROR_OCCURED              0x3000

#define EPLCN_ERROR_ENTRY_PROFILE_MASK_IN_TYPE            0x0FFF
#define EPLCN_ERROR_ENTRY_PROFILE_VENDOR_SPECIFIC         1
#define EPLCN_ERROR_ENTRY_PROFILE_COMMUNICATION           2

#define EPLCN_ERROR_ENTRY_E_DLL_BAD_PHYS_MODE             0x8161
#define EPLCN_ERROR_ENTRY_E_DLL_COLLISION                 0x8162
#define EPLCN_ERROR_ENTRY_E_DLL_COLLISION_TH              0x8163
#define EPLCN_ERROR_ENTRY_E_DLL_CRC_TH                    0x8164
#define EPLCN_ERROR_ENTRY_E_DLL_LOSS_OF_LINK              0x8165
#define EPLCN_ERROR_ENTRY_E_DLL_MAC_BUFFER                0x8166
#define EPLCN_ERROR_ENTRY_E_DLL_ADDRESS_CONFLICT          0x8201
#define EPLCN_ERROR_ENTRY_E_DLL_MULTIPLE_MN               0x8202
#define EPLCN_ERROR_ENTRY_E_PDO_SHORT_RX                  0x8210
#define EPLCN_ERROR_ENTRY_E_PDO_MAP_VERS                  0x8211
#define EPLCN_ERROR_ENTRY_E_NMT_ASND_MTU_DIF              0x8212
#define EPLCN_ERROR_ENTRY_E_NMT_ASND_MTU_LIM              0x8213
#define EPLCN_ERROR_ENTRY_E_NMT_ASND_TX_LIM               0x8214
#define EPLCN_ERROR_ENTRY_E_NMT_CYCLE_LEN                 0x8231
#define EPLCN_ERROR_ENTRY_E_DLL_CYCLE_EXCEED              0x8232
#define EPLCN_ERROR_ENTRY_E_DLL_CYCLE_EXCEED_TH           0x8233
#define EPLCN_ERROR_ENTRY_E_NMT_IDLE_LIM                  0x8234
#define EPLCN_ERROR_ENTRY_E_DLL_JITTER_TH                 0x8235
#define EPLCN_ERROR_ENTRY_E_DLL_LATE_PRES_TH              0x8236
#define EPLCN_ERROR_ENTRY_E_NMT_PREQ_CN                   0x8237
#define EPLCN_ERROR_ENTRY_E_NMT_PREQ_LIM                  0x8238
#define EPLCN_ERROR_ENTRY_E_NMT_PRES_CN                   0x8239
#define EPLCN_ERROR_ENTRY_E_NMT_PRES_RX_LIM               0x823A
#define EPLCN_ERROR_ENTRY_E_NMT_PRES_TX_LIM               0x823B
#define EPLCN_ERROR_ENTRY_E_DLL_INVALID_PORT              0x8241
#define EPLCN_ERROR_ENTRY_E_DLL_LOSS_PREQ_TH              0x8242
#define EPLCN_ERROR_ENTRY_E_DLL_LOSS_PRES_TH              0x8243
#define EPLCN_ERROR_ENTRY_E_DLL_LOSS_SOA_TH               0x8244
#define EPLCN_ERROR_ENTRY_E_DLL_LOSS_SOC_TH               0x8245
#define EPLCN_ERROR_ENTRY_E_NMT_BA1                       0x8410
#define EPLCN_ERROR_ENTRY_E_NMT_BA1_NO_MN_SUPPORT         0x8411
#define EPLCN_ERROR_ENTRY_E_NMT_BPO1                      0x8420
#define EPLCN_ERROR_ENTRY_E_NMT_BPO1_GET_IDENT            0x8421
#define EPLCN_ERROR_ENTRY_E_NMT_BPO1_DEVICE_TYPE          0x8422
#define EPLCN_ERROR_ENTRY_E_NMT_BPO1_VENDOR_ID            0x8423
#define EPLCN_ERROR_ENTRY_E_NMT_BPO1_PRODUCT_CODE         0x8424
#define EPLCN_ERROR_ENTRY_E_NMT_BPO1_REVISION_NO          0x8425
#define EPLCN_ERROR_ENTRY_E_NMT_BPO1_SERIAL_NO            0x8426
#define EPLCN_ERROR_ENTRY_E_NMT_BPO1_CONFIGURATION        0x8428
#define EPLCN_ERROR_ENTRY_E_NMT_BPO2                      0x8430
#define EPLCN_ERROR_ENTRY_E_NMT_BPRO                      0x8440
#define EPLCN_ERROR_ENTRY_E_NMT_WRONG_STATE               0x8480

EPL_CN_RESULT_T
EplCnStack_WriteErrorHistory(
                                          EPLCN_STACK_HANDLE_T              ptStackHandle,
                                          const EPLCN_STACK_ERROR_ENTRY_T*  ptEntry);

EPL_CN_RESULT_T
EplCnStack_WriteStatusEntry(
                                          EPLCN_STACK_HANDLE_T              ptStackHandle,
                                          unsigned int                      uiStatusEntryIndex,
                                          const EPLCN_STACK_ERROR_ENTRY_T*  ptEntry);

EPL_CN_RESULT_T
EplCnStack_WriteStaticErrorBitField(    EPLCN_STACK_HANDLE_T          ptStackHandle,
                                        unsigned int                  uiBitNo,
                                        EPLv2_CN_BOOLEAN              fBitValue);


EPL_CN_RESULT_T
EplCnStack_SetNumberOfStatusEntries(    EPLCN_STACK_HANDLE_T          ptStackHandle,
                                        unsigned int                  uiNumStatusEntries);

unsigned int
EplCnStack_GetNumberOfStatusEntries(    EPLCN_STACK_HANDLE_T          ptStackHandle);

#endif // EPLV2_CN_API_H_INCLUDED
